#!/usr/local/cpanel/3rdparty/bin/perl
use strict;

my $checkversion;

my @version = glob("/usr/local/cpanel/3rdparty/perl/[0-9]*");
@version = sort @version;
my $lastversion = $version[-1];
if ($lastversion =~ /(\d+)$/) {
	$checkversion = $1;
	if (-e "/usr/local/cpanel/3rdparty/perl/${checkversion}/bin/perl") {
		print "Updating for cPanel perl ${checkversion}\n";
		system("/usr/local/cpanel/scripts/update_local_rpm_versions --edit target_settings.perl${checkversion}-mailscanner installed");
		system("/usr/local/cpanel/scripts/check_cpanel_pkgs --fix --no-broken --no-digest --targets=perl${checkversion}-mailscanner");
		unless (-e "/usr/local/cpanel/3rdparty/perl/${checkversion}/lib/perl5/cpanel_lib/Sys/Hostname/Long.pm") {
			system("mkdir -p /opt/cpanel/perl5/${checkversion}/site_lib/");
			system("/bin/cp -af /usr/msfe/Missing/Modules/* /opt/cpanel/perl5/${checkversion}/site_lib/");
		}
	}
}
