#!/usr/local/cpanel/3rdparty/bin/perl
###############################################################################
# Copyright 2004-2020, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################
# User Configurable Variables
use strict;
use Fcntl qw(:DEFAULT :flock);

our ($altered, $emailreportsubject, $emailreportto, $input, $oldentry, $report,
     $spam_action_rules_def, $spam_action_rules_ini, $spam_scanning_rules_def,
	 $spam_scanning_rules_ini, $spamhigh_action_rules_def,
	 $spamhigh_action_rules_ini, $virus_delivery_rules_def,
	 $virus_delivery_rules_ini, $virus_scanning_rules_def, $cpanel,
	 $virus_scanning_rules_ini, $x, $xdomain, %msconfig, %validdomains, @data,
	 @har, @localdomains, @sar, @sbr, @sh, @ss, @ssr, @swr, @vdr, @vsr);

# Email the report to
$emailreportto =				'root';

# Subject of the report email
$emailreportsubject =			'Control Panel -> MailScanner Report';

$cpanel = 1;
unless (-e "/usr/local/cpanel/version") {$cpanel = 0}

my $owner = "mailnull:mail";
unless ($cpanel) {$owner = "mail:mail"}

# If the MailScanner front-end is installed all further option settings will be
# taken from the settings in WHM and not here

unless (-e "/usr/msfe/msconfig.txt") {
	# Either - To: From: FromOrTo: FromAndTo:
	$spam_scanning_rules_ini =		'To:';

	# Set to yes to scan for spam on new domains or no to not scan
	$spam_scanning_rules_def =		'yes';

	# Either - To: From: FromOrTo: FromAndTo:
	$virus_scanning_rules_ini =		'To:';

	# Set to yes to scan for viruses on new domains or no to not scan
	$virus_scanning_rules_def =		'yes';

	# Either - To: From: FromOrTo: FromAndTo:
	$spam_action_rules_ini =		'To:';

	# Actions for spam emails with a score >= 5 and < 20 can be: deliver; delete; forward spam@[domain] delete;
	$spam_action_rules_def =		'deliver';

	# Either - To: From: FromOrTo: FromAndTo:
	$spamhigh_action_rules_ini =	'To:';

	# Actions for spam emails with a score >= 20 can be: deliver; delete; forward spam@[domain] delete;
	$spamhigh_action_rules_def =	'deliver';

	# Either - To: From: FromOrTo: FromAndTo:
	$virus_delivery_rules_ini =		'FromOrTo:';

	# Set to yes to deliver cleaned emails that contained viruses on new domains or no to not deliver
	$virus_delivery_rules_def =		'no';
} else {
	open (IN, "<", "/usr/msfe/msconfig.txt") or die "Unable to open MSFE config file: $!";
	flock (IN, LOCK_SH);
	my @data = <IN>;
	close (IN);
	chomp @data;
	foreach my $line (@data) {
		my ($name,$value) = split(/\=/,$line,2);
		$msconfig{$name} = $value;
	}

	$spam_scanning_rules_ini = $msconfig{spam_scanning_rules_ini};
	$spam_scanning_rules_def = $msconfig{def_spam};
	$virus_scanning_rules_ini = $msconfig{virus_scanning_rules_ini};
	$virus_scanning_rules_def = $msconfig{def_virus};
	$spam_action_rules_ini = $msconfig{spam_action_rules_ini};
	$spam_action_rules_def = $msconfig{def_lspam};
	$spamhigh_action_rules_ini = $msconfig{spamhigh_action_rules_ini};
	$spamhigh_action_rules_def = $msconfig{def_hspam};
	$virus_delivery_rules_ini = $msconfig{virus_delivery_rules_ini};
	$virus_delivery_rules_def = $msconfig{def_dvirus};

	if ($msconfig{store} eq "yes") {
		if ($spam_action_rules_def !~ "store") {$spam_action_rules_def = "store $spam_action_rules_def"}
		if ($spamhigh_action_rules_def !~ "store") {$spamhigh_action_rules_def = "store $spamhigh_action_rules_def"}
	}
}

# No changes beyond this point
###############################################################################
# start main

$input = $ARGV[0];

&load_localdomains;
&load_rules;
&compare_rules;
&update_rules;
&email_report;

exit;

# end main
###############################################################################
# start load_localdomains
sub load_localdomains {
	open (IN, "<", "/proc/sys/kernel/hostname");
	my $hostname = <IN>;
	chomp $hostname;
	close (IN);
	if ($cpanel) {
		open (IN, "</etc/localdomains") or die "Unable to open /etc/localdomains for reading: $!";
		flock (IN, LOCK_SH);
		my @ldomains = <IN>;
		close (IN);
		chomp @ldomains;
		open (IN, "</etc/secondarymx");
		flock (IN, LOCK_SH);
		my @sdomains = <IN>;
		close (IN);
		chomp @sdomains;
		push @localdomains, @ldomains, @sdomains;
	} else {
		open (IN, "</etc/virtual/domains") or die "Unable to open /etc/virtual/domains for reading: $!";
		flock (IN, LOCK_SH);
		my @ldomains = <IN>;
		close (IN);
		chomp @ldomains;
		push @localdomains, @ldomains;
	}
	my $hit;
	foreach my $domain (@localdomains) {
		if ($domain eq $hostname) {
			$hit = 1;
			last;
		}
	}
	unless ($hit) {push @localdomains,$hostname}
	if (@localdomains == 0) {die "Failed: no local domains"}
}
# end load_localdomains
###############################################################################
# start load_rules
sub load_rules {
	if ($input ne "-bw") {
		open (IN, "<", "/usr/mailscanner/etc/rules/spam.scanning.rules") or die "Unable to open spam.scanning.rules for reading: $!";
		flock (IN, LOCK_SH);
		@ssr = <IN>;
		close (IN);
		chomp @ssr;
		open (IN, "<", "/usr/mailscanner/etc/rules/virus.scanning.rules") or die "Unable to open virus.scanning.rules for reading: $!";
		flock (IN, LOCK_SH);
		@vsr = <IN>;
		close (IN);
		chomp @vsr;
		open (IN, "<", "/usr/mailscanner/etc/rules/spam.action.rules") or die "Unable to open spam.action.rules for reading: $!";
		flock (IN, LOCK_SH);
		@sar = <IN>;
		close (IN);
		chomp @sar;
		open (IN, "<", "/usr/mailscanner/etc/rules/spamhigh.action.rules") or die "Unable to open spamhigh.action.rules for reading: $!";
		flock (IN, LOCK_SH);
		@har = <IN>;
		close (IN);
		chomp @har;
		open (IN, "<", "/usr/mailscanner/etc/rules/virus.delivery.rules") or die "Unable to open virus.delivery.rules for reading: $!";
		flock (IN, LOCK_SH);
		@vdr = <IN>;
		close (IN);
		chomp @vdr;
		open (IN, "<", "/usr/mailscanner/etc/rules/spam.score.rules") or die "Unable to open spam.score.rules for reading: $!";
		flock (IN, LOCK_SH);
		@ss = <IN>;
		close (IN);
		chomp @ss;
		open (IN, "<", "/usr/mailscanner/etc/rules/spamhigh.score.rules") or die "Unable to open spamhigh.score.rules for reading: $!";
		flock (IN, LOCK_SH);
		@sh = <IN>;
		close (IN);
		chomp @sh;
	}
	if (-e "/usr/msfe/spam.blacklist.rules") {
		open (IN, "<", "/usr/msfe/spam.blacklist.rules") or die "Unable to open /usr/msfe/spam.blacklist.rules for reading: $!";
		flock (IN, LOCK_SH);
		my @data = <IN>;
		close (IN);
		chomp @data;
		foreach my $entry (@data) {push (@sbr,$entry)}
	}
	open (IN, "<", "/usr/mailscanner/etc/rules/spam.blacklist.rules") or die "Unable to open spam.blacklist.rules for reading: $!";
	flock (IN, LOCK_SH);
	@data = <IN>;
	close (IN);
	chomp @data;
	$oldentry = "";
	foreach my $entry (@data) {
		if ($entry eq $oldentry) {next}
		$oldentry = $entry;
		if ($entry !~ /^To:\s\*\@\*/) {push (@sbr,$entry)}
	}
	if (-e "/usr/msfe/spam.whitelist.rules") {
		open (IN, "<", "/usr/msfe/spam.whitelist.rules") or die "Unable to open /usr/msfe/spam.whitelist.rules for reading: $!";
		flock (IN, LOCK_SH);
		my @data = <IN>;
		close (IN);
		chomp @data;
		foreach my $entry (@data) {push (@swr,$entry)}
	}
	open (IN, "<", "/usr/mailscanner/etc/rules/spam.whitelist.rules") or die "Unable to open spam.whitelist.rules for reading: $!";
	flock (IN, LOCK_SH);
	@data = <IN>;
	close (IN);
	chomp @data;
	$oldentry = "";
	foreach my $entry (@data) {
		if ($entry eq $oldentry) {next}
		$oldentry = $entry;
		if ($entry !~ /^To:\s\*\@\*/) {push (@swr,$entry)}
	}
}
# end load_rules
###############################################################################
# start compare_rules
sub compare_rules {
	$altered = 0;
	foreach my $domain (@localdomains) {
		$domain =~ s/\s//g;
		if ($domain =~ /^\#/) {next}
		if ($domain =~ /\.zz$/) {next}
		if ($domain =~ /^\n/) {next}
		if ($domain =~ /^\r/) {next}
		if ($input ne "-bw") {
			$xdomain = $domain;
			$xdomain =~ s/\[/\\\[/;
			$xdomain =~ s/\]/\\\]/;
			my $mod_spam_action_rules_def = $spam_action_rules_def;
			$mod_spam_action_rules_def =~ s/\[domain\]/$domain/ig;
			my $mod_spamhigh_action_rules_def = $spamhigh_action_rules_def;
			$mod_spamhigh_action_rules_def =~ s/\[domain\]/$domain/ig;
			if (not grep {$_ =~ /\*\@$xdomain\s+/} @ssr) {unshift (@ssr, "$spam_scanning_rules_ini\t\*\@$domain\t$spam_scanning_rules_def");$report .= "$domain added to spam.scanning.rules\n";$altered = 1}
			if (not grep {$_ =~ /\*\@$xdomain\s+/} @vsr) {unshift (@vsr, "$virus_scanning_rules_ini\t\*\@$domain\t$virus_scanning_rules_def")}
			if (not grep {$_ =~ /\*\@$xdomain\s+/} @sar) {unshift (@sar, "$spam_action_rules_ini\t\*\@$domain\t$mod_spam_action_rules_def");$report .= "$domain added to spam.action.rules\n";$altered = 1}
			if (not grep {$_ =~ /\*\@$xdomain\s+/} @har) {unshift (@har, "$spamhigh_action_rules_ini\t\*\@$domain\t$mod_spamhigh_action_rules_def");$report .= "$domain added to spamhigh.action.rules\n";$altered = 1}
			if (not grep {$_ =~ /\*\@$xdomain\s+/} @vdr) {unshift (@vdr, "$virus_delivery_rules_ini\t\*\@$domain\t$virus_delivery_rules_def");$report .= "$domain added to virus.delivery.rules\n";$altered = 1}
		}
		$validdomains{$domain} = 1;
	}
	if ($input ne "-bw") {
		for ($x=0;$x < @ssr;$x++) {
			if (($ssr[$x] =~ /\@([^\t\s]*)/) and ($ssr[$x] !~ /^\#/)) {
				if (not $validdomains{$1} and ($1 ne "")) {splice (@ssr,$x,1);$report .= "$1 removed from spam.scanning.rules\n";$altered = 1}
			}
		}
		for ($x=0;$x < @vsr;$x++) {
			if (($vsr[$x] =~ /\@([^\t\s]*)/) and ($vsr[$x] !~ /^\#/)) {
				if (not $validdomains{$1} and ($1 ne "")) {splice (@vsr,$x,1)}
			}
		}
		for ($x=0;$x < @sar;$x++) {
			if (($sar[$x] =~ /\@([^\t\s]*)/) and ($sar[$x] !~ /^\#/)) {
				if (not $validdomains{$1} and ($1 ne "")) {splice (@sar,$x,1);$report .= "$1 removed from spam.action.rules\n";$altered = 1}
			}
		}
		for ($x=0;$x < @har;$x++) {
			if (($har[$x] =~ /\@([^\t\s]*)/) and ($har[$x] !~ /^\#/)) {
				if (not $validdomains{$1} and ($1 ne "")) {splice (@har,$x,1);$report .= "$1 removed from spamhigh.action.rules\n";$altered = 1}
			}
		}
		for ($x=0;$x < @vdr;$x++) {
			if (($vdr[$x] =~ /\@([^\t\s]*)/) and ($vdr[$x] !~ /^\#/)) {
				if (not $validdomains{$1} and ($1 ne "")) {splice (@vdr,$x,1);$report .= "$1 removed from virus.delivery.rules\n";$altered = 1}
			}
		}
		for ($x=0;$x < @ss;$x++) {
			if (($ss[$x] =~ /\@([^\t\s]*)/) and ($ss[$x] !~ /^\#/)) {
				if (not $validdomains{$1} and ($1 ne "")) {splice (@ss,$x,1);$report .= "$1 removed from spam.score.rules\n";$altered = 1}
			}
		}
		for ($x=0;$x < @sh;$x++) {
			if (($sh[$x] =~ /\@([^\t\s]*)/) and ($sh[$x] !~ /^\#/)) {
				if (not $validdomains{$1} and ($1 ne "")) {splice (@sh,$x,1);$report .= "$1 removed from spamhigh.score.rules\n";$altered = 1}
			}
		}
	}
	for ($x=0;$x < @sbr;$x++) {
		if (($sbr[$x] =~ /\@([^\t\s\*]*)/) and ($sbr[$x] !~ /^\#/)) {
			if (not $validdomains{$1} and ($1 ne "") and ($1 ne "*")) {splice (@sbr,$x,1);$report .= "$1 removed from spam.blacklist.rules\n";$altered = 1}
		}
	}
	for ($x=0;$x < @swr;$x++) {
		if (($swr[$x] =~ /\@([^\t\s\*]*)/) and ($swr[$x] !~ /^\#/)) {
			if (not $validdomains{$1} and ($1 ne "") and ($1 ne "*")) {splice (@swr,$x,1);$report .= "$1 removed from spam.whitelist.rules\n";$altered = 1}
		}
	}
}
# end compare_rules
###############################################################################
# start update_rules
sub update_rules {
	if ($altered or ($input eq "-bw")) {
		if ($input ne "-bw") {
			my @newvsr;
			my $lastline;
			my $default;
			foreach my $line (@vsr) {
				if ($line eq $lastline) {next}
				if ($line =~ /^\#/) {push @newvsr, $line}
				elsif ($line =~ /postmaster/) {push @newvsr, $line}
				elsif ($line =~ /^FromOrTo:\s*default/) {push @newvsr, "FromOrTo:\tdefault yes"; $default = 1}
				elsif ($line =~ /no$/i) {push @newvsr, $line}
				$lastline = $line;
			}
			unless ($default) {push @newvsr, "FromOrTo:\tdefault yes"}
			@vsr = @newvsr;
			open (OUT, ">", "/usr/mailscanner/etc/rules/spam.scanning.rules") or die "Unable to open spam.scanning.rules for writing: $!";
			flock (OUT, LOCK_EX);
			foreach my $line (@ssr) {print OUT "$line\n"}
			close (OUT);
			open (OUT, ">", "/usr/mailscanner/etc/rules/virus.scanning.rules") or die "Unable to open virus.scanning.rules for writing: $!";
			flock (OUT, LOCK_EX);
			foreach my $line (@vsr) {print OUT "$line\n"}
			close (OUT);
			open (OUT, ">", "/usr/mailscanner/etc/rules/spam.action.rules") or die "Unable to open spam.action.rules for writing: $!";
			flock (OUT, LOCK_EX);
			foreach my $line (@sar) {print OUT "$line\n"}
			close (OUT);
			open (OUT, ">", "/usr/mailscanner/etc/rules/spamhigh.action.rules") or die "Unable to open spamhigh.action.rules for writing: $!";
			flock (OUT, LOCK_EX);
			foreach my $line (@har) {print OUT "$line\n"}
			close (OUT);
			open (OUT, ">", "/usr/mailscanner/etc/rules/virus.delivery.rules") or die "Unable to open virus.delivery.rules for writing: $!";
			flock (OUT, LOCK_EX);
			foreach my $line (@vdr) {print OUT "$line\n"}
			close (OUT);
			open (OUT, ">", "/usr/mailscanner/etc/rules/spam.score.rules") or die "Unable to open spam.score.rules for writing: $!";
			flock (OUT, LOCK_EX);
			foreach my $line (@ss) {print OUT "$line\n"}
			close (OUT);
			open (OUT, ">", "/usr/mailscanner/etc/rules/spamhigh.score.rules") or die "Unable to open spamhigh.score.rules for writing: $!";
			flock (OUT, LOCK_EX);
			foreach my $line (@sh) {print OUT "$line\n"}
			close (OUT);
		} else {
			$report = "System black and white lists updated\n";
		}
		open (OUT, ">", "/usr/mailscanner/etc/rules/spam.blacklist.rules") or die "Unable to open spam.blacklist.rules for writing: $!";
		flock (OUT, LOCK_EX);
		foreach my $line (@sbr) {print OUT "$line\n"}
		close (OUT);
		open (OUT, ">", "/usr/mailscanner/etc/rules/spam.whitelist.rules") or die "Unable to open spam.whitelist.rules for writing: $!";
		flock (OUT, LOCK_EX);
		foreach my $line (@swr) {print OUT "$line\n"}
		close (OUT);
		if (-e "/usr/msfe/newmsbe.txt") {
			system("perl /usr/msfe/msbe.pl -a");
		} else {
			system("/sbin/service MailScanner reload");
		}
	}
}
# end update_rules
###############################################################################
# start email_report
sub email_report {
	if ($altered or ($input eq "-bw")) {
		if (($input eq "-i") or ($input eq "-bw")) {
			print $report;
		} else {
			open (MAIL, "|/usr/sbin/sendmail -t > /dev/null") or die $!;
			print MAIL "From: $emailreportto\n";
			print MAIL "To: $emailreportto\n";
			print MAIL "Subject: $emailreportsubject\n\n";
			print MAIL $report;
			close (MAIL) or die $!;
		}
	}
}
# end email_report
###############################################################################
